unit IWTemplateProcessorHTML;

interface

Uses
  Classes,
  {$IFDEF VSNET}
  System.ComponentModel,
  System.Drawing,
  IWTemplateFilesConverter,
  {$ELSE}
  {$ENDIF}
  IWContainerLayout, IWRenderContext, IWTypes, IWBaseInterfaces,
  IWBaseHTMLInterfaces, IWBaseRenderContext, IWStreams;

Type
  {$IFDEF VSNET}
  [TypeConverter(typeof(TIWTemplateFilesConverter))]
  {$ENDIF}
  TIWTemplateFiles = class(TPersistent)
  private
    FDefault: string;
    FIE: string;
    FNetscape6: string;
    FNetscape7: string;
    FOpera: string;
    //
  protected
    procedure AssignTo(ADest: TPersistent); override;
  public
    constructor Create(ADefault, AIE, ANetscape6, ANetscape7, AOpera: String); overload;
  published
    property Default: string read FDefault write FDefault;
    property IE: string read FIE write FIE;
    property Netscape6: string read FNetscape6 write FNetscape6;

    property Netscape7: string read FNetscape7 write FNetscape7;
    property Opera: string read FOpera write FOpera;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWTemplateProcessorHTML.bmp}
  TIWTemplateProcessorHTML = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWTemplateProcessorHTML), 'TIWTemplateProcessorHTML.bmp')]
  {$ENDIF}
  TIWTemplateProcessorHTML = class(TIWContainerLayout)
  private
    FMasterFormTag: Boolean;
    FTagType: TIWTemplateLayoutHTMLTagType;
    FTemplates: TIWTemplateFiles;
    //
    procedure SetTemplates(const AValue: TIWTemplateFiles);

    procedure SetMasterFormTag(const AValue: Boolean);

  protected
    FOnUnknownTag: TIWUnknownTagEvent;
    FOnBeforeProcess: TIWTemplateProcessEvent;
    FOnAfterProcess: TIWTemplateProcessEvent;

    function DoUnknownTag(const AName: string): string;
    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    function Able: Boolean; override;
    procedure ProcessControl(AContainerContext: TIWContainerContext; APageContext: TIWBaseHTMLPageContext;
      AControl: IIWBaseHTMLComponent); override;
    procedure Process(AStream: TIWRenderStream;
      AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext); override;
    procedure ProcessStream(AStream: TIWRenderStream; ATemplateStream: TStream;
      AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext);
    function TemplatePathname: string;
    function RenderStyle(AControl: IIWBaseHTMLControl): string; override;
  published
    property MasterFormTag: Boolean read FMasterFormTag write SetMasterFormTag default true;
    property TagType: TIWTemplateLayoutHTMLTagType read FTagType write FTagType;
    property Templates: TIWTemplateFiles read FTemplates write SetTemplates;
    property OnUnknownTag: TIWUnknownTagEvent read FOnUnknownTag write FOnUnknownTag;
    property OnBeforeProcess: TIWTemplateProcessEvent read FOnBeforeProcess write FOnBeforeProcess;
    property OnAfterProcess: TIWTemplateProcessEvent read FOnAfterProcess write FOnAfterProcess;
  end;

implementation

Uses
  SysUtils,
  CopyPrsr,
  {$IFDEF VCL6PRABOVE}
  Variants,
  {$ENDIF}
  {$IFDEF VSNET}
  System.IO,
  {$ENDIF}
  IWGlobal, IWUtils, IWRegion, IWHTML40Interfaces, IWHTMLTag, IWApplication,
  IWTemplateProcessing, SWStrings, SWSystem, IWBaseContainerLayout,
  IWBaseLayoutComponent, IWMarkupLanguageTag;

{ TIWTemplateProcessorHTML }

function TIWTemplateProcessorHTML.Able: Boolean;
{$IFDEF VSNET}
var
  LInfo : FileInfo;
{$ENDIF}
begin
  Result := False;
  if Enabled then begin
    Result := FileExists(TemplatePathname) or Assigned(FOnBeforeProcess);

{$IFDEF VSNET}
  if FileExists(TemplatePathname) then begin
    LInfo := FileInfo.Create(TemplatePathname);
    if LInfo.Length = 0 then begin
      Result := false;
    end;
  end;
{$ENDIF}
  end;
end;

procedure TIWTemplateProcessorHTML.SetMasterFormTag(const AValue: Boolean);
begin
  FMasterFormTag := AValue;
end;

procedure TIWTemplateProcessorHTML.InitControl;
begin
  inherited;
  MasterFormTag := True;
  FTemplates := TIWTemplateFiles.Create;

  SetAllowFrames(False);
  SetLayoutType(ltFlow);
  // SetSupportsContainer(True);
end;

procedure TIWTemplateProcessorHTML.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FTemplates);
  inherited;
end;

function TIWTemplateProcessorHTML.DoUnknownTag(const AName: string): string;
begin
  Result := '';
  if Assigned(OnUnknownTag) then begin
    OnUnknownTag(AName, Result);
  end;
end;

procedure TIWTemplateProcessorHTML.Process(AStream: TIWRenderStream;
  AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext);
var
  LSrcStream: TStream;
  LMasterSrc: TStream;
  LPostStream: TStream;
  LMasterTemplate: string;
  LTemplatePathname : string;
  LLocalizedTemplatePathname : string;
  LAcceptLang : string;
begin
  Initialize(APageContext.WebApplication.Browser);

  // use localized template if any
  LTemplatePathname := TemplatePathname;
  LAcceptLang := APageContext.WebApplication.Request.GetFieldByName('Accept-Language');
  LAcceptLang := Fetch(LAcceptLang,',');
  LAcceptLang := Fetch(LAcceptLang,'-');
  LLocalizedTemplatePathname := Fetch(LTemplatePathname,'.') + '.' + LAcceptLang + '.' + LTemplatePathname;
  if FileExists(LLocalizedTemplatePathname) then begin
    LTemplatePathname := LLocalizedTemplatePathname;
  end else begin
    LTemplatePathname := TemplatePathname; 
  end;

  if FileExists(LTemplatePathname) then begin
    LSrcStream := TFileStream.Create(LTemplatePathname, fmOpenRead + fmShareDenyWrite);
    try
      if Assigned(FOnBeforeProcess) then begin
        OnBeforeProcess(LSrcStream);
      end;
      if HTML40FormInterface(Container.InterfaceInstance)<>nil then begin
        LMasterTemplate := GGetWebApplicationThreadVar.ActiveMasterTemplate;
        if LMasterTemplate<>'' then begin
          LMasterTemplate := GServerController.TemplateDir + LMasterTemplate;
          if FileExists(LMasterTemplate) then begin
            LMasterSrc := TFileStream.Create(LMasterTemplate, fmOpenRead + fmShareDenyWrite);
            try
              MergeTemplates(LSrcStream,LMasterSrc);
            finally
              FreeAndNil(LMasterSrc);
            end;
          end;
        end;
      end;
      ProcessStream(AStream, LSrcStream, AContainerContext, APageContext);
    finally
      FreeAndNil(LSrcStream);
    end;
  end else begin
    LSrcStream := nil;
    if Assigned(FOnBeforeProcess) then begin
      OnBeforeProcess(LSrcStream);
    end;
    	if Assigned(LSrcStream) then begin
	      try
        if HTML40FormInterface(Container.InterfaceInstance)<>nil then begin
          LMasterTemplate := GGetWebApplicationThreadVar.ActiveMasterTemplate;
	        if LMasterTemplate<>'' then begin
            LMasterTemplate := GServerController.TemplateDir + LMasterTemplate;
	          if FileExists(LMasterTemplate) then begin
	            LMasterSrc := TFileStream.Create(LMasterTemplate, fmOpenRead + fmShareDenyWrite);
	            try
	              MergeTemplates(LSrcStream,LMasterSrc);
    	        finally
	              FreeAndNil(LMasterSrc);
	            end;
    	      end;
	        end;
        end;
        ProcessStream(AStream, LSrcStream, AContainerContext, APageCOntext);
      finally
        FreeAndNil(LSrcStream);
      end;
    end;
  end;
  if Assigned(FOnAfterProcess) then begin
    LPostStream := TStream(AStream);
    OnAfterProcess(LPostStream);
    if LPostStream<>AStream then try
      AStream.Size := 0;
      AStream.CopyFrom(LPostStream,0);
    finally
      LPostStream.Free;
    end;
  end;
end;

procedure TIWTemplateProcessorHTML.ProcessStream(AStream: TIWRenderStream; ATemplateStream: TStream;
 AContainerContext: TIWContainerContext; APageContext: TIWBasePageContext);
var
  i: Integer;
  LHeaderHasBeenWritten: Boolean;
  LParser: TCopyParser;
  LHTMLStream: TMemoryStream;
//  LChar: Char;
  LTagName: string;
  LTagParams: string;
  LName: string;
  LValue: String;
  LTerminated: Boolean;
  AFormProcessing: Boolean;
  LProcessedControls: TStringList;
  LPageContext: TIWBaseHTMLPageContext;

  procedure RemoveStyleSheet(LCtrlName: String);
  Var
    i: Integer;
    LControl: IIWHTML40Control;
    LComponent: IIWBaseHTMLComponent;
//    LLayout: TIWBaseLayoutComponent;
    LSelectorName : String;
    LCSS : String;
  begin
    if SupportsInterface(AContainerContext.Components[LCtrlName], IIWHTML40Control) then begin
      LControl := HTML40ControlInterface(AContainerContext.Components[LCtrlName]);
      LComponent := BaseHTMLComponentInterface(AContainerContext.Components[LCtrlName]);
      LSelectorName := '.' + UpperCase(LComponent.HTMLName) + 'CSS';
      with TIWPageContext40(APageContext).StyleTag do begin
        for i := 0 to Contents.Count - 1 do begin
          if Contents.Items[i] is TIWTextElement then begin
            LCSS := TIWTextElement(Contents.Items[i]).Text;  
            if AnsiPos(LSelectorName, LCSS) = 1 then begin

//              LLayout := HTML40ContainerInterface(AContainerContext.Components[LCtrlName]).ContainerContext.LayoutManager; try
//                HTML40ContainerInterface(AContainerContext.Components[LCtrlName]).ContainerContext.LayoutManager := Self;
//                ProcessControl(HTML40ContainerInterface(AContainerContext.Components[LCtrlName]).ContainerContext, LPageContext, LComponent);
//              finally
//                HTML40ContainerInterface(AContainerContext.Components[LCtrlName]).ContainerContext.LayoutManager := LLayout;
//              end;
              Contents.Items[i].Free;
              Contents.Delete(i);
              break;
            end;
          end;
        end;
      end;
    end;
  end;

  procedure CheckTag(AParser: TCopyParser; const AEndTagChar1, AEndTagChar2: Char);
  var
    LCtrlName: string;
  begin
    with AParser do begin
      SkipToken(True);
      LCtrlName := TokenString;
      SkipToken(True);
      while Token = '.' do begin
        SkipToken(True);
        LCtrlName := LCtrlName + '.' + TokenString;
        SkipToken(True);
      end;

      if Length(LCtrlName) > 0 then begin
        if AContainerContext.IsValidComponent(LCtrlName) then begin
          LProcessedControls.Add(LCtrlName);
          RemoveStyleSheet(LCtrlName);
        end;
      end;
      // SkipToken(True);
      if TagType <> ttBorland then begin
        CheckToken(AEndTagChar1);
        SkipToken(True);
      end;
      CheckToken(AEndTagChar2);
      SkipToken(True);
    end;
  end;

  function ProcessTag(AParser: TCopyParser; const AEndTagChar1, AEndTagChar2: Char): string;
  var
    LCtrlName: string;
    LHTML: TIWHTMLTag;
    LControl: IIWBaseHTMLComponent;
    LTmp: TIWRenderStream;
    LComponentContext: TIWBaseComponentContext;
    LContainerContext: TIWContainerContext;
  begin
    result := '';
    with AParser do begin
      SkipToken(True);
      LCtrlName := TokenString;
      SkipToken(True);
      while Token = '.' do begin
        SkipToken(True);
        LCtrlName := LCtrlName + '.' + TokenString;
        SkipToken(True);
      end;

      if Length(LCtrlName) > 0 then begin
        if AContainerContext.IsValidComponent(LCtrlName) then begin
          LProcessedControls.Add(LCtrlName);
          LControl := BaseHTMLComponentInterface(AContainerContext.Components[LCtrlName]);
          LHTML := TIWBaseHTMLComponentContext(AContainerContext.ComponentContext[LCtrlName]).HTMLTag;
          RemoveStyleSheet(LCtrlName);
          Result := '';
          if Assigned(LHTML) then try
            LTmp:=TIWRenderStream.Create;
            try
              LComponentContext := AContainerContext.ComponentContext[LCtrlName];
              LContainerContext := LComponentContext.ContainerContext;
              if AContainerContext<>LContainerContext then begin
                AContainerContext.AddComponent(LComponentContext,LComponentContext.MarkupLanguageTag);
                try
                  LComponentContext.ContainerContext := AContainerContext;
                  ProcessControl(AContainerContext, TIWBaseHTMLPageContext(APageContext), LControl);
                  LControl.MakeHTMLTag(LHTML, LTmp);
                  Result := LTmp.Extract;
                finally
                  AContainerContext.RemoveComponent(LComponentContext);
                end;
              end else begin
                LControl.MakeHTMLTag(LHTML, LTmp);
                Result := LTmp.Extract;
              end;
            finally
              LTmp.Free;
            end;
          except on EAbort do end;
        end else begin
          Result := DoUnknownTag(LCtrlName);
        end;
      end;
      // SkipToken(True);
      if TagType <> ttBorland then begin
        CheckToken(AEndTagChar1);
        SkipToken(True);
      end;
      CheckToken(AEndTagChar2);
      SkipToken(True);
    end;
  end;

  procedure SkipAndOutput(AParser: TCopyParser);
  begin
    with AParser do begin
      CopyTokenToOutput;
      SkipToken(True);
    end;
  end;

  procedure SkipOverNextHTMLTag(AParser: TCopyParser);
  begin
    with AParser do begin
      SkipToToken('<');
      SkipToken(True);
      CheckToken('/');
      SkipToToken('>');
      SkipToken(True);
    end;
  end;

  procedure WriteHead(AStream: TIWRenderStream);
  begin
    LHeaderHasBeenWritten := True;
    with TIWPageContext40(APageContext) do begin
      StreamWrite(AStream, '<HEAD>' + DebugEOL
        + iif( GServerController.CharSet , '<META HTTP-EQUIV="Content-Type" CONTENT="text/html; CHARSET='+GServerController.CharSet+'">' + DebugEOL)
        + HeadContent + DebugEOL);
        if StyleTag.Contents.Count > 0 then begin
          StyleTag.Render(AStream);
        end;
      StreamWrite(AStream, ScriptSection(TIWPageContext40(APageContext)));
    end;
  end;

  procedure RemoveHiddenInput(AFormTag: TIWHTMLTag; AControl: String);
  Var
    i: Integer;
    LTag: TIWHTMLTag;
  begin
    for i := 0 to AFormTag.Contents.Count - 1 do begin
      if AFormTag.Contents.Items[i] is TIWHTMLTag then begin
        LTag := AFormTag.Contents.Items[i] as TIWHTMLTag;
        if AnsiSameText(LTag.Params.Values['name'], AControl) then begin
          AFormTag.Contents.Delete(i);
          LTag.Free;
          break;
        end;
      end;
    end;
  end;

begin
  LPageContext := TIWBaseHTMLPageContext(APageCOntext);
  LHTMLStream := TMemoryStream.Create;
{  while ATemplateStream.Read(LChar, 1) > 0 do begin
    case LChar of
      '''': LHTMLStream.WriteString( '&#39;' );
    else;
      LHTMLStream.WriteString( LChar );
    end;
  end;}
//  LHTMLStream.Position := 0;
  LProcessedControls := TStringList.Create;
  LProcessedControls.Sorted := true;
  LHeaderHasBeenWritten := false;
  AFormProcessing := SupportsInterface(Container.InterfaceInstance, IIWHTML40Form);


  //
  // This section merely parses the whole ATemplateStream and elicits
  // valid control names in special tags and puts them in the
  // LProcessedControls list
  //============================================================================
  LTerminated := APageContext.WebApplication.Terminated;
  try
    LParser := TCopyParser.Create(ATemplateStream, LHTMLStream); try
      with LParser do begin
        while Token <> toEOF do begin
          case Token of
            // process normal HTML tag
            //------------------------------------------------------------------
            '<': begin

              // SkipToken first in case of short circuit
              if (SkipToken(True) = '#') and (TagType = ttBorland) then begin
                CheckTag(LParser, '#', '>');
              end else begin
                // <!DOCTYPE - etc. this is why TokenString + SkipTo
                LTagName := TokenString;
                // Must be separate from above, SkipToToken modfies result value of TokenString
                LTagName := LTagName + SkipToToken('>');
                //
                i := Pos(' ', LTagName);
                if i > 0 then begin
                  LTagParams := Copy(LTagName, i + 1, MaxInt);
                  SetLength(LTagName, i - 1);
                  LTagParams := StringReplace(LTagParams, '../files/', LPageContext.URLBase + '/files/'
                   , [rfReplaceAll, rfIgnoreCase]);
                end else begin
                  LTagParams := '';
                end;
                // if AFormProcessing or LHeaderHasBeenWritten then begin
                  StreamWrite(LHTMLStream, '<' + Trim(LTagName + ' ' + LTagParams) + '>');
                  SkipToken(True);// Added. Fixes CR bug. 26/04
                {end
                else
                  SkipToken(False);// Added. Fixes CR bug. 26/04}
              end;
            end;

            // process special tag
            //------------------------------------------------------------------
            '{': begin
              // SkipToken first in case of short circuit
              LValue := SkipTo(2);
              if (LValue = '{%') and (TagType = ttIntraWeb) then begin
                // if (SkipToken(True) = '%') and (TagType = ttIntraWeb) then begin

                // check if the special tag contains valid control name
                // and if so put that name in the LProcessedControls list
                CheckTag(LParser, '%', '}');
              end else begin
                // StreamWrite(AStream, '{');
                SkipAndOutput(LParser);
              end;
            end else begin
              // if AFormProcessing or LHeaderHasBeenWritten then begin
                SkipAndOutput(LParser);
              {end else
                SkipToken(False);// Added. Fixes CR bug. 26/04}
            end;
          end;
        end;
      end;
    finally
      FreeAndNil(LParser);
    end;

    // below happens the real processing of the template
    //==========================================================================
    ATemplateStream.Position := 0;
    LParser := TCopyParser.Create(ATemplateStream, AStream); try
      with LParser do begin

        while Token <> toEOF do begin
          case Token of

            '<': begin
              // SkipToken first in case of short circuit
              if (SkipToken(True) = '#') and (TagType = ttBorland) then begin
                // raise Exception.Create('This should be processed in the first iteration');
                StreamWrite(AStream, ProcessTag(LParser, '#', '>'));
              end else begin
                // <!DOCTYPE - etc. this is why TokenString + SkipTo
                LTagName := TokenString;
                // Must be separate from above, SkipToToken modfies result value of TokenString
                LTagName := LTagName + SkipToToken('>');

                // elicit tag params
                //--------------------------------------------------------------
                i := Pos(' ', LTagName);
                if i > 0 then begin
                  LTagParams := Copy(LTagName, i + 1, MaxInt);
                  SetLength(LTagName, i - 1);
                  LTagParams := StringReplace(LTagParams, '../files/', LPageContext.URLBase + '/files/'
                   , [rfReplaceAll, rfIgnoreCase]);
                end else begin
                  LTagParams := '';
                end;

                if AnsiSameText(LTagName, 'BODY') then begin
                  // process BODY tag
                  //------------------------------------------------------------

                  if AFormProcessing then begin

                    // it's form template
                    //----------------------------------------------------------

                    // process tag params
                    while Length(LTagParams) > 0 do begin
                      LName := Trim(Fetch(LTagParams));
                      LValue := LName;
                      LName := Trim(Fetch(LValue, '='));
                      if AnsiPos('"', LValue) > 0 then begin
                        Fetch(LValue, '"');
                        if AnsiPos('"', LValue) = 0 then begin
                          LTagParams := LValue + LTagParams;
                          LValue := Fetch(LTagParams, '"');
                        end else begin
                          LValue := Fetch(LValue, '"');
                        end;
                      end else begin
                        if AnsiPos('''', LValue) > 0 then begin
                          Fetch(LValue, '''');
                          if AnsiPos('''', LValue) = 0 then begin
                            LTagParams := LValue + LTagParams;
                            LValue := Fetch(LTagParams, '''');
                          end else begin
                            LValue := Fetch(LValue, '''');
                          end;
                        end;
                      end;
                      if LName <> '' then begin
                        if AnsiSameText(LName, 'BGCOLOR') then begin
                          if LPageContext.BodyTag.Params.Values['BGCOLOR'] = '' then begin
                            LPageContext.BodyTag.AddStringParam('BGCOLOR', LValue);
                          end;
                        end else begin
                          if AnsiSameText(LName, 'OnLoad') then begin
                            TIWPageContext40(APageContext).AddToInitProc(LValue + ';');
                          end else begin
                            if AnsiSameText(LName, 'OnBlur') then begin
                               LPageContext.BodyTag.Params.Values[LName] := LPageContext.BodyTag.Params.Values[LName] + LValue + ';';
                            end else begin
                              LPageContext.BodyTag.Params.Values[LName] := LValue;
                            end;
                          end;
                        end;
                      end;
                    end;


                    // write HEAD contents if hasn't been written
                    if not LHeaderHasBeenWritten then begin
                      WriteHead(AStream);
                    end;
                    LPageContext.BodyTag.ClosingTag := cbFalse;
                    LPageContext.BodyTag.Render(AStream);
                    SkipToken(True);
                    if not LTerminated and MasterFormTag and not NoFormTag then begin
                      StreamWrite(AStream, '<FORM onSubmit="return FormDefaultSubmit();" style="display:inline;">');
                    end;
                  end else begin

                    // it's NOT a form template
                    //----------------------------------------------------------
                    SkipToken(False); // Added. Fixes CR bug. 26/04
                    if (Container.InterfaceInstance is TIWCustomRegion) then begin
                      if not LTerminated and MasterFormTag then begin
                        StreamWrite(AStream, '<FORM onSubmit="return FormDefaultSubmit();" style="display:inline;">');
                      end;
                    end;
                  end;
                  LHeaderHasBeenWritten := true;
                end else if AnsiSameText(LTagName, '/BODY') then begin

                  // proces /BODY tag
                  //------------------------------------------------------------
                  if AFormProcessing then begin
                    if not LTerminated and (TIWPageContext40(APageContext).UpdateMode = umAll) then begin
                      if MasterFormTag and not NoFormTag then begin // Close master form tag
                        StreamWriteLn(AStream, '</FORM>');
                      end;
                      for i := 0 to AContainerContext.ComponentsCount - 1 do begin
                        if SupportsInterface(AContainerContext.ComponentsList[i], IIWInputControl) then begin
                          if SupportsInterface(AContainerContext.ComponentsList[i], IIWBaseComponent) then begin
                            LTagName := BaseHTMLComponentInterface(AContainerContext.ComponentsList[i]).HTMLName;
                            if LProcessedControls.IndexOf(LTagName) = -1 then begin
                              RemoveHiddenInput(LPageContext.FormTag, LTagName);
                            end;
                          end;
                        end;
                      end;

                      LPageContext.FormTag.Render(AStream);
                    end;
                    StreamWrite(AStream, '</BODY>');
                    SkipToken(True); // Added. Fixes CR bug. 26/04
                  end else begin
                    if (Container.InterfaceInstance is TIWCustomRegion) then begin
                      if not LTerminated then begin
                        if MasterFormTag and not NoFormTag then begin // Close master form tag
                          StreamWriteLn(AStream, '</FORM>');
                        end;
                      end;
                    end;
                    SkipToken(False); // Added. Fixes CR bug. 26/04
                    LHeaderHasBeenWritten := false;
                  end;
                end else if AnsiSameText(LTagName, 'HEAD') then begin

                  // proces HEAD tag
                  //------------------------------------------------------------
                  if AFormProcessing then begin
                    if not LHeaderHasBeenWritten then begin
                      WriteHead(AStream);
                    end;
                    SkipToken(True);
                  end else
                    SkipToken(False);
                end else if AnsiSameText(LTagName, 'TITLE') then begin

                  // proces TITLE tag
                  //------------------------------------------------------------
                  if AFormProcessing then begin
                    if Length(LPageContext.Title) > 0 then begin
                      SkipOverNextHTMLTag(LParser);
                      StreamWriteLn(AStream, '<TITLE>' + LPageContext.Title + '</TITLE>');
                    end else begin
                      StreamWrite(AStream, '<TITLE>');
                      SkipToken(True); // Added. Fixes CR bug. 26/04
                    end;
                  end;
                end
                else begin
                  // it isn't neither BODY, /BODY, HEAD, TITLE
                  //------------------------------------------------------------

                  if AFormProcessing or LHeaderHasBeenWritten then begin
                    StreamWrite(AStream, '<' + Trim(LTagName + ' ' + LTagParams) + '>');
                    SkipToken(True);// Added. Fixes CR bug. 26/04
                  end
                  else
                    SkipToken(False);// Added. Fixes CR bug. 26/04
                end;
              end;
            end;

            // special tag
            //------------------------------------------------------------------
            '{': begin
              // SkipToken first in case of short circuit
              LValue := SkipTo(2);
              if (LValue = '{%') and (TagType = ttIntraWeb) then begin
                // if (SkipToken(True) = '%') and (TagType = ttIntraWeb) then begin
                // raise Exception.Create('This should be processed in the first iteration');
                StreamWrite(AStream, ProcessTag(LParser, '%', '}'));
              end else begin
                // StreamWrite(AStream, '{');
                SkipAndOutput(LParser);
              end;
            end else begin
              if AFormProcessing or LHeaderHasBeenWritten then begin
                SkipAndOutput(LParser);
              end else
                SkipToken(False);// Added. Fixes CR bug. 26/04
            end;
          end;
        end;
      end;
    finally
      FreeAndNil(LParser);
    end;
  finally
    FreeAndNil(LProcessedControls);
    FreeAndNil(LHTMLStream);
  end;
end;

procedure TIWTemplateProcessorHTML.SetTemplates(const AValue: TIWTemplateFiles);
begin
  FTemplates.Assign(AValue);
end;

function TIWTemplateProcessorHTML.TemplatePathname: string;
Var
  S: String;
begin
  if Templates.Default = '' then begin
    // This is for subtemplates of regions. Right now containername returns:
    // formName.regionName. We rename it to formNameRegionName and that way
    // if no name is specified for the templates for regions, it uses this as
    // the default one
    if Assigned(Container) then begin
      // Remove the T from subclass name (AFTER the .)
      if (Length(s) > 0) and (Pos('.T', UpperCase(s)) > 0) then begin
        s := StringReplace(UpperCase(Container.ContainerClassNAme), '.T', '', []);
      end;
      s := StringReplace(Container.ContainerClassName, '.', '', []);
      // Remove T from it
      if (Length(s) > 0) and (AnsiSameText(s[1], 'T')) then begin
        Delete(s,1,1);
      end;
      s := s + '.html';
    end else begin
      s := '';
    end;
    if Assigned(GServerController) and FileExists(GServerController.TemplateDir + s) then begin
      FTemplates.Default := s;
    end;
  end;

  if (Browser = brNetscape6) and (Length(Templates.Netscape6) > 0) then begin
    Result := Templates.Netscape7;
  end else if (Browser = brNetscape6) and (Length(Templates.Netscape6) > 0) then begin
    Result := Templates.Netscape6;
  end else if (Browser = brIE) and (Length(Templates.IE) > 0) then begin
    Result := Templates.IE;
  end else if (Browser = brOpera) and (Templates.Opera <> '') then begin
    Result := Templates.Opera;
  end else if Length(Templates.Default) > 0 then begin
    Result := Templates.Default;
  end;
  Result := GServerController.TemplateDir + Result;
end;

procedure TIWTemplateProcessorHTML.ProcessControl(
  AContainerContext: TIWContainerContext; APageContext: TIWBaseHTMLPageContext; AControl: IIWBaseHTMLComponent);
Var
  LHTML: TIWMarkupLanguageTag;
  LCompCOntext: TIWBaseHTMLComponentContext;
  LStyle:string;
  LTag:string;
begin
  if SupportsInterface(AControl.InterfaceInstance, IIWHTML40Component) then begin
    with HTML40ComponentInterface(AControl.InterfaceInstance) do begin
      LCompContext := TIWBaseHTMLComponentContext(AContainerContext.ComponentContext[AControl.HTMLName]);
      LHTML := LCompContext.HTMLTag;
      if Assigned(LHTML) then begin
        LHTML.AddStringParam('CLASS', RenderCSSClass(nil));
        // relative positioning is not used from IW controls

        // remove absolute positioning values
        LStyle := LHTML.Params.Values['STYLE'];
        LHTML.Params.Values['STYLE'] := '';
        while LStyle<>'' do begin
          LTag := Fetch(LStyle,':',true,true);
          if (LTag='position') or (LTag='left') or (LTag='top') or (LTag='width') or (LTag='height') or (LTag='z-index') then begin
            Fetch(LStyle,';',true,true);
          end else begin
            LHTML.Params.Values['STYLE'] := LHTML.Params.Values['STYLE'] + LTag + ':' + Fetch(LStyle,';',true,true) + ';'
          end;
        end;
        LHTML.AddStringParam('STYLE', RenderStyle(LCompContext) + LHTML.Params.Values['STYLE']);
      end;
    end;
  end;
  inherited ProcessControl(AContainerContext, APageContext, AControl);
end;

function TIWTemplateProcessorHTML.RenderStyle(AControl: IIWBaseHTMLControl): string;
var
  LControl: IIWHTML40Control;
  LComponent: IIWBaseHTMLComponent;
begin
  LControl := AControl as IIWHTML40Control;
  LComponent := BaseHTMLComponentInterface(AControl.InterfaceInstance);
  Result := (inherited RenderStyle(AControl));
  if SupportsInterface(LComponent.InterfaceInstance, IIWHTML40Container) then begin
    result := result + 'position:relative;';
  end;
end;

{ TIWTemplateFiles }

procedure TIWTemplateFiles.AssignTo(ADest: TPersistent);
begin
  if ADest is TIWTemplateFiles then begin
    with TIWTemplateFiles(ADest) do begin
      Default := Self.Default;
      IE := Self.IE;
      Netscape6 := Self.Netscape6;
      Netscape7 := Self.Netscape7;
      Opera := Self.Opera;
    end;
  end else begin
    inherited AssignTo(ADest);
  end;
end;

constructor TIWTemplateFiles.Create(ADefault, AIE, ANetscape6, ANetscape7,
  AOpera: String);
begin
  inherited Create;
  FDefault := ADefault;
  FIE := AIE;
  FNetscape6 := ANetscape6;
  FNetscape7 := ANetscape7;
  FOpera := AOpera;
end;

end.
